//
//  WXKBookmarkWindowController_Communication.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/05/12.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
//
//  Some part of this source code is derived from AirHPhone.m, 
//  written by raktajino in AH-K3001V Bookmark Utility and distributed
//  under BSD license.
//  Communicational protocol to AH-K3001V was referred to ``AirH" 
//  AH-K3001 station'' (http://www.softclub.jp/zoro/ce/usb.html), written
//  by Zoroyoshi and distributed under BSD license.
//  See the following about copyrights.
//
//
//  Created by raktajino on Thu Jun 17 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
//		Copyright (c) 04 Zoroyoshi, Japan
//		All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKBookmarkWindowController.h"
#import "WXKProgressWindowController.h"
#import "WXKPhone.h"


@implementation WXKBookmarkWindowController (Communication)


- (BOOL)receiveWithPassword:(NSString *)password error:(NSError **)error
{
	// Begin to communicate with Kyopon.
	WXKPhone *phone = [[WXKPhone alloc] init];
	
	WXKProgressWindowController	*progressWindowController = [[WXKProgressWindowController alloc] initWithParentWindow:[self window]];
	
	// Receive data from Kyopon.
	NSArray *dataArray;
	BOOL isSucceed = [phone receiveAllItemsOfDataType:WXKPhoneBookmarkDataType
										intoDataArray:&dataArray
										 withPassword:password
											 progress:progressWindowController
												error:error];
	
	[phone release];
	[progressWindowController release];
	
	if (isSucceed) {
	
//		[foldersTableView setNeedsDisplay:NO];
//		[itemsTableView setNeedsDisplay:NO];
		
		// If successfully received data, then parse the data.
		
		NSManagedObjectContext *context = [self managedObjectContext];
		
		// remove all existing bookmarks
		NSEnumerator *enumerator = [[itemsController allObjects] objectEnumerator];
		id item;
		while (item = [enumerator nextObject]) {
			[context deleteObject:item];
		}
		[context processPendingChanges];
		
		NSArray *allFolders = [foldersController allObjects];
		NSManagedObject *indexManager = [itemsController valueForKey:@"indexManager"];
		
		int i;
		for (i = 0; i < [dataArray count]; i++) {
		
			NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
			
			const UInt8 *buffer = [[dataArray objectAtIndex:i] bytes];
			
			NSString *stringFields[4] = {nil, nil, nil, nil};
			UInt8 *p  = (UInt8 *)buffer + 13;
			
			while (p[1] >= 1 && p[1] <= 4) {
				UInt8  *field       = p + 7;
				SInt32  fieldLength = p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
				SInt32  fieldIndex  = p[1] - 1;
				if (fieldLength == 0x01000000) {
					fieldLength = p[2];
				}
				stringFields[fieldIndex] = [[[NSString alloc] initWithBytes:field length:fieldLength encoding:NSShiftJISStringEncoding] autorelease];
				p = field + fieldLength;
				
				if (stringFields[0] == nil && stringFields[1] != nil && stringFields[2] != nil && stringFields[3] != nil) {
					
					// if bookmark title is ommited
					stringFields[0] = [[stringFields[1] copy] autorelease];		// copy URL field into title field.
					
					
					// The following step is commented out since this bug seems to be fixed in recent firmware.
					
//					// In this case the folder number is not sent by AH-K3001V.
//					// (It might be a bug in AH-K3001V firmware 1.4.)
//					// Therefore, we guess the folder number same as what is added latest.
//					// By using this method incorrect folder number will be set when the bookmark is top of the folder.
//					// However, since there is no way to avoid it, this specifi
//					
//					id lastBookmark = [[itemsController allObjects] lastObject];
//					if (lastBookmark) {
//						stringFields[3] = [[lastBookmark valueForKeyPath:@"folder.order"] stringValue];
//					} else {
//						stringFields[3] = @"0";
//					}
				}
				
				if (stringFields[0] != nil && stringFields[1] != nil && stringFields[2] != nil && stringFields[3] != nil) {
					// finish reading all fields.
					// set bookmark attributes to read fields.
					id bookmark = [NSEntityDescription insertNewObjectForEntityForName:@"Bookmark"
																inManagedObjectContext:context];
					
					NSNumber *index = [NSNumber numberWithInt:[stringFields[2] intValue]];
					
					id folder = nil;
					int folderIndex = [stringFields[3] intValue];
					if ([allFolders count] > folderIndex) folder = [allFolders objectAtIndex:folderIndex];
					
					[bookmark setValue:[NSNumber numberWithInt:i] forKey:@"order"];
					[bookmark setValue:stringFields[0] forKey:@"title"];
					[bookmark setValue:stringFields[1] forKey:@"url"];
					[bookmark setValue:index forKey:@"index"];
					[bookmark setValue:folder forKey:@"folder"];
					[bookmark setValue:indexManager forKey:@"indexManager"];
					break;
				}
			}
			[pool release];
		}
//		[foldersTableView setNeedsDisplay:YES];
//		[itemsTableView setNeedsDisplay:YES];
		
		return YES;
	} else {
		return NO;
	}
}


- (BOOL)sendWithPassword:(NSString *)password error:(NSError **)error
{
	NSArray *bookmarks = [itemsController allObjects];
	NSMutableArray *dataArray = [NSMutableArray arrayWithCapacity:[bookmarks count]];
	
	int i;
	for (i = 0; i < [bookmarks count]; i++) {
//		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		
		id		bookmark		= [bookmarks objectAtIndex:i];
		NSData	*titleData		= [[bookmark valueForKey:@"title"] dataUsingEncoding:NSShiftJISStringEncoding
																allowLossyConversion:YES];
		NSData	*urlData		= [[bookmark valueForKey:@"url"] dataUsingEncoding:NSShiftJISStringEncoding
															  allowLossyConversion:YES];
		SInt32	number			= [[bookmark valueForKey:@"index"] longValue];
		SInt32	folderNumber	= [[bookmark valueForKeyPath:@"folder.order"] longValue];
		
//		NSMutableData *data = [NSMutableData data];
		UInt8 writeBuffer[4096];
//		UInt8 *writeBuffer = [data mutableBytes];
		
		SInt32 len;
		UInt8 *p = writeBuffer;
		*p++ = 0x1c;
		
		// write a bookmark title into sending buffer.
		*p++ = 0x1e; *p++ = 1; *p++ = 2;
		len = [titleData length];
		*p++ = (UInt8)len; *p++ = (UInt8)(len >> 8); *p++ = (UInt8)(len >> 16); *p++ = (UInt8)(len >> 24);
		memcpy(p, [titleData bytes], len); p += len;
		
		// write a bookmark URL into sending buffer.
		*p++ = 0x1e; *p++ = 2; *p++ = 2;
		len = [urlData length];
		*p++ = (UInt8)len; *p++ = (UInt8)(len >> 8); *p++ = (UInt8)(len >> 16); *p++ = (UInt8)(len >> 24);
		memcpy(p, [urlData bytes], len); p += len;
		
		// write a bookmark memory number into sending buffer.
		*p++ = 0x1e; *p++ = 3; *p++ = 2;
		*p++ = 2; *p++ = 0; *p++ = 0; *p++ = 0;
		*p++ = number / 10 + '0'; *p++ = number % 10 + '0';
		
		// write a  bookmark folder number into sending buffer.
		*p++ = 0x1e; *p++ = 4; *p++ = 2;
		*p++ = 2; *p++ = 0; *p++ = 0; *p++ = 0;
		*p++ = folderNumber / 10 + '0'; *p++ = folderNumber % 10 + '0';
		
		[dataArray addObject:[NSData dataWithBytes:writeBuffer length:p - writeBuffer]];
//		[dataArray addObject:[NSData dataWithData:data]];
//		[pool release];
	}
	
	WXKPhone *phone = [[[WXKPhone alloc] init] autorelease];
	WXKProgressWindowController	*progressWindowController = [WXKProgressWindowController sharedWindowControllerWithParentWindow:[self window]];
	
	return [phone writeAllItemsOfDataType:WXKPhoneBookmarkDataType
								dataArray:dataArray
							 withPassword:password
								 progress:progressWindowController
									error:error];
}


@end
